function JFilterDialog(owner, parent, name, caption, action, method, rect)
{
	var self = this,
		_rendered = false,
		_disposed = false,
		_dragHandler = null;

	this.initialize(owner, parent, name, caption, action, rect, null);

	this.isForm   = true;
	this.previous = parent;
	this.method   = method;
	this.methods  = (cmRender | cmLoad);
	this.value    = 0;

	this.owner.addImage("close-icon", "close.gif", "form");

	this.rect.normalize(this.owner.getDocument().body);

	this.render = render;
	this.load   = load;
	this.dispose = dispose;

	this.isRendered = isRendered;
	this.change = change;
	this.close  = close;

	this.owner.activeForm = this;

	function render(fs)
	{
		if (_rendered)
			return;


		fs.append('<div class="dialogForm" id="' + self.name + '" style="' + self.rect + '">');
		fs.append('  <div id="' + self.name + '_title" class="form_titlebar">');
		fs.append('    <span id="' + self.name + '_caption" class="form_caption">' + self.caption + '</span>');
//		fs.append('    <img id="' + self.name + '_closeicon" class="form_bordericon" alt="' + hiCloseIcon + '">');
		fs.append('  </div>');

		fs.append(	'<div class="dialogForm_inlet" id="' + self.name + '_inlet" style="top: ' + eval(fmDragbarHeight + fmBorderWidth) + 'px; height: ' + eval(self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + eval(self.rect.width - 2 * fmBorderWidth) + 'px ">');

		self.controls.forEach( function(child)
		{
			if (utils.inSet(cmRender, child.methods))
				child.render(fs);
		}, self);

		fs.append(	'</div>');
		fs.append('</div>');

		_rendered = true;
	}

	function load()
	{
		self.owner.getDocument().body.appendChild(self.$$());

		var fltCount = 0;
		self.controls.forEach( function(child)
		{
			if (child.constructor == JFilter)
				fltCount++;

			if (utils.inSet(cmLoad, child.methods))
				child.load();
		}, self);


		self.owner.getObject(self.name + '_epk_fid').onchange.attach(self.change);

		if (fltCount > 0)
			self.$$('_btn_ok').onclick = self.close;
		else
			self.$$('_btn_ok').disabled = "disabled";

		self.$$('_btn_cancel').onclick   = self.close;
		var btnNoFilter = self.$$('_btn_nofilter');
		if (btnNoFilter != null)
			btnNoFilter.onclick = self.close;


		self.$$('_check0').onclick = self.close;
		self.$$('_check1').onclick = self.close;
		self.$$('_check2').onclick = self.close;


		this.value = self.dataset.get('fid');
		change.call(self);

		self.owner.splash(true);
		self.owner.setSplashInfo('');

		if (typeof(DragHandler) != 'undefined')
			_dragHandler = new DragHandler(self.$$(), self.$$('_title'));
	}

	function isRendered()
	{
		return _rendered;
	}

	function change()
	{
		self.controls.forEach( function(child)
		{
			if (child.constructor == JFilter)
			{
				var splitted = child.name.split("_");
				self.$(child.name).style.display = (this.value == parseInt(splitted[splitted.length - 1]) ? "block" : "none");
			}
		}, this);
	}

	function close(e)
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		var query = new Postback();
		var element;

		element = utils.getEventElement(e);

		while ((element.className != 'button') && (element.type != 'checkbox'))
		{
			element = element.parentNode;
		}

		var doPost = true;
		if (element.id == self.name + '_btn_ok')
		{
			query.set('rst', 1);
			query.set('dat', escape(self.dataset.getCurrentRecord().toString()));
		}
		else
		if (element.id == self.name + '_btn_cancel')
		{
			query.set('rst', 0);
		}
		else
		if (element.id == self.name + '_btn_nofilter')
		{
			query.set('rst', -1);
		}
		else
		if (element.id == self.name + '_check0')
		{
			query.set('chb', 0);
			query.set('dat', element.checked ? '1' : '0');

		}
		else
		if (element.id == self.name + '_check1')
		{
			query.set('chb', 1);
			query.set('dat', element.checked ? '1' : '0');
		}
		else
		if (element.id == self.name + '_check2')
		{
			query.set('chb', 2);
			query.set('dat', element.checked ? '1' : '0');
		}
		else
			doPost = false;


//		var rec = self.dataset.getCurrentRecord();
//		if (rec != null)
			query.set('fid', self.dataset.get('fid'));
		query.set('afm', self.name);


		if (doPost)
			self.owner.post(raSetFilter, query);
	}

	function dispose()
	{
		if (_disposed)
			return;

		if (_dragHandler != null)
			_dragHandler.dispose();

		self.owner.getObject(self.name + '_epk_fid').onchange.detach(self.change);

		self.$$('_btn_ok').onclick       = null;
		self.$$('_btn_cancel').onclick   = null;
		var btnNoFilter = self.$$('_btn_nofilter');
		if (btnNoFilter != null)
			btnNoFilter.onclick = null;

		self.disposeChildren();

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}
}



function JFilter(owner, parent, name, caption, dataset, isDefault)
{
	var self = this;
	var _disposed = false;

	this.initialize(owner, parent, name, caption, null, null, null, null, dataset);

	this.methods  = (cmRender | cmLoad);
	this.isDefault= isDefault;

	this.render  = render;
	this.load    = load;
	this.dispose = dispose;

	function render(fs)
	{
		var prect = self.getParentObject().rect;
		var rect = new JRect('10;40;;');

		rect.width  = prect.width - 25;
		rect.height = prect.height - (rect.top + 55);

		fs.append('<div class="filter" id="' + this.name + '" style="' + rect + '">');

		self.controls.forEach( function(child)
		{
			if (utils.inSet(cmRender, child.methods))
				child.render(fs);
		}, self);

		fs.append('</div>');
	}

	function load()
	{
		self.controls.forEach( function(child)
		{
			if (utils.inSet(cmLoad, child.methods))
				child.load();
		}, self);
	}

	function dispose()
	{
		if (_disposed)
			return;

		self.disposeChildren();

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JFilterDialog.inheritsFrom(ControlBase);
JFilter.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();